;-------------------------------------------------------------------------------
; ZX X-MAS '19 - NORMAL OR ULA PLUS COLORS INITIALIZATION
;
;       (/&&&/\&\  /%/  \&\  /%/   /%)(#)(&\ /%###&\ /###)  ()/%|  /&&&\
;         /%/  \&\/%/    \&\/%/,--,|#||#||#| |#| |#| |&&\     |#| (&___&)
;        /%/   /%/\&\    /%/\&\'--'|#||#||#| |###|#|  \&&|    |#|    (&&)
;       /&&&/)/%/  \&\  /%/  \&\   |#||#||#| |#| |#| (###/    |#| (&&&&/
;
; Copyright AbaddoN (C)2018-2019
; Code and gfx by: G.o.D. / AbaddoN
; Mzx by: ern0 / AbaddoN
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; Normal or ULA Plus colors initialization
; in:  A: 0: normal colors / 1: ULA Plus
; out: -
; mod: AF,BC,DE,HL
COLORS_INIT:
	or	a					; A=0: normal colors / A=1: ULA Plus
	jr	nz,CI_SetULAPlus

	; Initialize normal ZX Spectrum colors
	ld	a,1					; border color in middle
	ld	(COLOR_BORDER_MID),a
	
	ld	a,$48
	ld	(SET_PAPER_BKG_COLOR+1),a ; background paper color -for erase paper fx
	ld	(MOVE_OUT_EMPTY_ATTR+1),a ; -for move out tree erase right column

	xor	a					; border color in top and bottom
	ld	(COLOR_BORDER_WIDESCREEEN),a
	out	($FE),a				; set border color

	ld	a,$08				; right and left bottom attributes
	ld	(COLOR_RIGHTBOTTOM_ATTR),a
	ld	(COLOR_LEFTBOTTOM_ATTR),a


	ld	hl,BKG_RIGHT_ATTR_NORMCOL ; background attributes right 22 columns
	ld	(RIGHT_BKG_ATTR+1),hl
	
	ld	hl,MLTCOL_NORMCOL_ATTR	; multicolor 192 lines attributes
	ld	(MLTCOL_ATTR_LOADED_ADDR+1),hl

	ld	hl,BKG_TREE_NORMCOL_ATTR	; scrolled background tree attrs
	ld	de,BKG_TREE_IMAGE+8
	ld	bc,15*24+$100
CI_BkgTreeAttrLoop:
	ld	a,(hl)
	inc	hl
	ld	(de),a
	ld	a,e
	add	a,9
	ld	e,a
	ld	a,d
	adc	a,0
	ld	d,a
	dec	c
	jr	nz,CI_BkgTreeAttrLoop
	djnz	CI_BkgTreeAttrLoop
	
	ld	hl,VAP_IN_RIBBON_ATTR_1+1 ; attribute corrections
	ld	(hl),$7A
	ld	hl,VAP_IN_RIBBON_ATTR_2+1
	ld	(hl),$3A
	ld	hl,VAP_IN_RIBBON_ATTR_3+1
	ld	(hl),$32
	ld	hl,VAP_IN_RIBBON_ATTR_4+1
	ld	(hl),$7A
	ld	hl,VAP_IN_RIBBON_ATTR_5+1
	ld	(hl),$3A
	ld	hl,VAP_IN_RIBBON_ATTR_6+1
	ld	(hl),$32
	ld	hl,VAP_IN_RIBBON_SOCKS+1
	ld	(hl),$4F
	ld	hl,VAP_IN_RIBBON_SINCLAIR+1
	ld	(hl),$0E
	
	ld	hl,OC_FadeInAttrNormCol-1 ; open curtain fx, fade in point
	ld	(OPEN_CURTAIN_FADEIN+1),hl
	
	ret
CI_SetULAPlus:
	; Initialize normal ULA Plus colors
	xor	a					; border color in middle
	ld	(COLOR_BORDER_MID),a

	; xor	a
	ld	(SET_PAPER_BKG_COLOR+1),a ; background paper color -for erase paper fx
	ld	(MOVE_OUT_EMPTY_ATTR+1),a ; -for move out tree erase right column

	ld	a,1					; border color in top and bottom
	ld	(COLOR_BORDER_WIDESCREEEN),a
	out	($FE),a				; set border color

	xor	a					; right and left bottom attributes
	ld	(COLOR_RIGHTBOTTOM_ATTR),a
	ld	(COLOR_LEFTBOTTOM_ATTR),a

	ld	hl,BKG_RIGHT_ATTR_ULAPLUS ; background attributes right 22 columns
	ld	(RIGHT_BKG_ATTR+1),hl

	ld	hl,MLTCOL_ULAPLUS_ATTR	; multicolor 192 lines attributes
	ld	(MLTCOL_ATTR_LOADED_ADDR+1),hl

	ld	hl,OC_FadeInAttrULAPlus-1 ; open curtain fx, fade in point
	ld	(OPEN_CURTAIN_FADEIN+1),hl
	
	; call	SET_ULAPLUS_PALETTE		; Set ULA Plus mode and palettes

	; ret

;-------------------------------------------------------------------------------
; Set ULA plus palette
; Original code by Andrew Owen, Copyright (c) 2009
; in:  -
; out: -
; mod: AF,BC,HL,AF'

SET_ULAPLUS_PALETTE:
	ld	hl,ULAPLUS_PALETTE
	ld	bc,$BF3B				; register select
	ld	a,$40				; mode group
	out	(c),a
	ld	a,1
	ld	b,$FF				; choose register port
	out	(c),a				; turn palette mode on
	xor	a					; first register

SUP_SetRegisters:
	ld	b,$BF				; choose register port
	out	(c),a				; select register
	ex	af,af'				; save current register select
	ld	a,(hl)				; get data
	ld	b,$FF				; choose data port
	out	(c),a				; set it
	ex	af, af'				; restore current register
	inc	hl					; advance pointer
	inc	a					; increase register
	cp	$40					; are we nearly there yet?
	jr	nz,SUP_SetRegisters		; repeat until all 64 have been done
	ret						; return

ULAPLUS_PALETTE:
	defb	$20,$40,$60,$84,$B0,$D6,$FA,$FF,$6F,$21,$2C,$10,$18,$7C,$DC,$FF
	defb	$20,$40,$60,$84,$B0,$D6,$FA,$FF,$6F,$40,$60,$84,$B0,$D6,$FA,$FF
	defb	$20,$60,$2C,$10,$18,$BC,$FC,$FF,$6F,$20,$2C,$10,$18,$7C,$FC,$FF
	defb	$01,$10,$3C,$40,$65,$B9,$DD,$FF,$6F,$10,$40,$65,$80,$B9,$DD,$FF
